<?php
/**
 * Top Ranking
 * https://webenginecms.org/
 * 
 * @version 1.1.0
 * @author Lautaro Angelico <http://lautaroangelico.com/>
 * @copyright (c) 2013-2019 Lautaro Angelico, All Rights Reserved
 * @build w3c8c718b75a0f1fa1a557f7f9d70877
 */

echo '<div class="page-title"><span>'.lang('module_titles_txt_10',true).'</span></div>';

$onlineIndicator = '<span style="background-color: #00cc00;display: inline-block;text-indent: -1000px;overflow: hidden;-moz-border-radius: 50%;-webkit-border-radius: 50%;border-radius: 50%;-khtml-border-radius: 50%;width: 10px;height: 10px;"></span>';
$offlineIndicator = '<span style="background-color: #aaaaaa;display: inline-block;text-indent: -1000px;overflow: hidden;-moz-border-radius: 50%;-webkit-border-radius: 50%;border-radius: 50%;-khtml-border-radius: 50%;width: 10px;height: 10px;"></span>';

try {
	
	$TopRanking = new \Plugin\TopRanking\TopRanking();
	$rankingData = $TopRanking->getRankingData();
	if(!is_array($rankingData)) throw new Exception(lang('topranking_error_2',true));
	
	$Rankings = new Rankings();
	$Rankings->rankingsMenu();
	
	echo '<table class="table rankings-table">';
		echo '<tr>';
			echo '<td class="text-center"></td>';
			if($TopRanking->showClass()) echo '<td class="text-center">'.lang('topranking_txt_1',true).'</td>';
			echo '<td class="text-center">'.lang('topranking_txt_2',true).'</td>';
			if($TopRanking->showResets()) echo '<td class="text-center">'.lang('topranking_txt_9',true).'</td>';
			echo '<td class="text-center">'.lang('topranking_txt_3',true).'</td>';
			if($TopRanking->showKills()) echo '<td class="text-center">'.lang('topranking_txt_4',true).'</td>';
			if($TopRanking->showDuels()) echo '<td class="text-center">'.lang('topranking_txt_5',true).'</td>';
			if($TopRanking->showGens()) echo '<td class="text-center">'.lang('topranking_txt_6',true).'</td>';
			if($TopRanking->showGuild()) echo '<td class="text-center">'.lang('topranking_txt_7',true).'</td>';
			if($TopRanking->showOnlineStatus()) echo '<td class="text-center">'.lang('topranking_txt_8',true).'</td>';
		echo '</tr>';
		$i = 1;
		foreach($rankingData as $playerInfo) {
			
			$gensImage = $TopRanking->getGensImage($playerInfo['gens']);
			$classImage = $TopRanking->getClassImage($playerInfo['class']);
			$duelsWin = '<span style="'.$TopRanking->getDuelsWinStyle().'">'.number_format($playerInfo['duelswon']).'</span>';
			$duelsLose = '<span style="'.$TopRanking->getDuelsLoseStyle().'">'.number_format($playerInfo['duelslost']).'</span>';
			$onlineStatus = $TopRanking->isOnline($playerInfo['name']) ? $onlineIndicator : $offlineIndicator;
			
			echo '<tr>';
				echo '<td class="text-center" style="vertical-align:middle;">'.$i.'</td>';
				if($TopRanking->showClass()) echo '<td class="text-center" style="vertical-align:middle;">'.$classImage.'</td>';
				echo '<td class="text-center" style="vertical-align:middle;">'.playerProfile($playerInfo['name']).'</td>';
				if($TopRanking->showResets()) echo '<td class="text-center" style="vertical-align:middle;">'.number_format($playerInfo['resets']).'</td>';
				echo '<td class="text-center" style="vertical-align:middle;">'.number_format($playerInfo['combinedLevel']).'</td>';
				if($TopRanking->showKills()) echo '<td class="text-center" style="vertical-align:middle;">'.number_format($playerInfo['kills']).'</td>';
				if($TopRanking->showDuels()) echo '<td class="text-center" style="vertical-align:middle;">'.$duelsWin.' / '.$duelsLose.'</td>';
				if($TopRanking->showGens()) echo '<td class="text-center" style="vertical-align:middle;">'.$gensImage.'</td>';
				if($TopRanking->showGuild()) echo '<td class="text-center" style="vertical-align:middle;">'.guildProfile($playerInfo['guild']).'</td>';
				if($TopRanking->showOnlineStatus()) echo '<td class="text-center" style="vertical-align:middle;">'.$onlineStatus.'</td>';
			echo '</tr>';
			
			$i++;
		}
	echo '</table>';
	
} catch(Exception $ex) {
	message('error', $ex->getMessage());
}